local bootup = ui.MediaPlayer()
bootup:setSource('assets/bootup.mp4'):setAutoPlay(true)

function Motec ()

    display.image {
        image = "assets/Motec_DJR.dds",
        pos = vec2(0,0),
        size = vec2(859, 480)
    }
end

function text ()

    display.text {
        text = string.format("%d", car.lapCount),
        pos = vec2(174, 115),
        letter = vec2(50, 60),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -25
    }

    display.text {
        text = string.format("%.1f", ac.getCar().brakeBias * 100),
        pos = vec2(350,310),
        letter = vec2(50, 60),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -21
    }

    display.text {
        text = string.format("%d", car.racePosition),
        pos = vec2(70, 115),
        letter = vec2(50, 60),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -13
    }

	    local color
	if car.performanceMeter > 0 then
    	color = rgbm(1, 0, 0, 1) 
	elseif car.performanceMeter < 0 then
    	color = rgbm(0, 1, 0, 1) 
	else
   	    color = rgbm(1, 1, 1, 1) 
	end

	display.text {
   	 text = string.format("%.2f", car.performanceMeter), 
   	 pos = vec2(355, 070),
   	 letter = vec2(30,40),
   	 font = "bosch",
   	 color = color, 
   	 width = 44,
   	 alignment = 1,
   	 spacing = -10
	}

display.text {
    text = string.format("%02d:%02d.%03d", 
        math.floor(car.bestLapTimeMs / 60000),
        math.floor((car.bestLapTimeMs % 60000) / 1000), 
        car.bestLapTimeMs % 1000),
    pos = vec2(40, 015),
    letter = vec2(35,45),
    font = "bosch",
    color = rgbm(1, 1, 1, 1),
    width = 46,
    alignment = 1,
    spacing = -8
}

display.text {
    text = string.format("%.2f",car.fuel / car.fuelPerLap),
    pos = vec2(030,180),
    letter = vec2(70, 70),
    font = "bosch",
    color = rgbm(1,1,1,1),
    width = 46,
    alignment = 1,
    spacing = -13
}

    display.text {
        text = string.format("%.f", car.waterTemperature),
        pos = vec2(60, 300),
        letter = vec2(40, 50),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -13
    }

    
    display.text {
        text = string.format("%.f", car.exhaustTemperature),
        pos = vec2(50, 400),
        letter = vec2(40, 50),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -13
    }

    display.text {
        text = string.format("%d", car.rpm),
        pos = vec2(350, 405),
        letter = vec2(50, 50),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -15
    }

    display.text {
        text = string.format("%.1f", car.batteryVoltage), 
        pos = vec2(690, 400),
        letter = vec2(40, 50),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -8
    }

    display.text {
        text = string.format("%d", car.oilTemperature),
        pos = vec2(710, 300),
        letter = vec2(50, 60),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -13
    }

    display.text {
        text = string.format("%d", car.speedKmh), 
        pos = vec2(640, 030),
        letter = vec2(80, 90),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -13
    }

    local gearText = tostring(car.gear) 
    if car.gear == -1 then
        gearText = "R"
    end
    if car.gear == 0 then
        gearText = "N"
    end
    display.text {
        text = gearText,
        pos = vec2(700, 140),
        letter = vec2(090, 115),
        font = "bosch",
        width = 70,
        alignment = 1,
        spacing = 0,
        color = rgbm(1,1,1,1),
    }
end


function images()

    if (car.batteryVoltage <= 11) then
        display.image {
            image = "assets/Battery_white.dds",
            pos = vec2(350, 240), 
            size = vec2(37, 33)
        }
    end

    if (car.engineLifeLeft <= 600) then
        display.image {
            image = "assets/motor.dds",
            pos = vec2(286, 230), 
            size = vec2(57, 57)
        }
    end

    if (car.headlightsActive == true) then
        display.image {
            image = "assets/headlight.dds",
            pos = vec2(390, 230), 
            size = vec2(57, 57)
        }
    end

    if (car.oilTemperature == 100) then
        display.image {
            image = "assets/oiltemp.dds",
            pos = vec2(440, 225), 
            size = vec2(67, 67)
        }
    end

    if (car.fuel <= 10) then
        display.image {
            image = "assets/lowfuel.dds",
            pos = vec2(550, 230),
            size = vec2(57, 57)
        }
    end

    if (car.rpm <= 1) then
        display.image {
            image = "assets/boost.dds",
            pos = vec2(500, 230), 
            size = vec2(57, 57)
        }
    end
end

function Overrev ()
    if (car.rpm >= 8000) then
        display.image {
          image = 'assets/revwarning.dds',
          pos = vec2(60,70),
        size = vec2(739, 360)
        }
    end
end

function Pitlimiter ()
    if (car.manualPitsSpeedLimiterEnabled == true)  then
        display.image {
          image = 'assets/pitlimiter.dds',
          pos = vec2(60,70),
        size = vec2(739, 360)
        }
    end
end

function Black_Orange ()
    if sim.raceFlagType == ac.FlagType.ReturnToPits then
        display.image {
            image = 'assets/Penalty.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end

function Finish ()
    if sim.raceFlagType == ac.FlagType.Finished then
        display.image {
            image = 'assets/Checkeredflag.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end

function Caution ()
    if sim.raceFlagType == ac.FlagType.Caution then
        display.image {
            image = 'assets/Caution.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end

function Blue ()
    if sim.raceFlagType == ac.FlagType.FasterCar then
        display.image {
            image = 'assets/Yourslow.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end

function script.update(dt)
    if (bootup:ended()) then
        Motec()
        text()
        images()
        Overrev()
        Pitlimiter()
        Blue()
        Caution()
        Finish()
        Black_Orange()
    else
        ui.drawImage(bootup, vec2(), vec2(859, 480))
    end
end